﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary
{
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    public class ItineraryContextualActionsExport
    {
        [Export(typeof(ExtensionLink))]
        [ExtensionSiteMetadata(TargetExtensionSite = "ItineraryLinks")]
        public ExtensionLink EmailLinkExport
        {
            get
            {
                return new ExtensionLink()
                {
                    LinkText = "Email",
                    RouteLink = new RouteValueDictionary(new { controller = "EmailItinerary", action = "Email", area = RouteTableConfiguration.AreaName }),
                    Attributes = new Dictionary<string, object> {
                        { "id", "emailItineraryLink" },
                        { "class", "email" },
                        { "rel", "nofollow" }
                    }
                };
            }
        }

        [Export(typeof(RouteValueDictionary))]
        [ExtensionSiteMetadata(TargetExtensionSite = "ItineraryToolbox")]
        public RouteValueDictionary EmailToolboxExport
        {
            get
            {
                return new RouteValueDictionary(new { controller = "EmailItinerary", action = "GetEmailToolbox", area = RouteTableConfiguration.AreaName });
            }
        }
    }
}